### 概述

**使用场景**

* TCP/IP作为一种标准的网络通信协议，提供了可靠的连接和数据传输能力，使得各种工业设备能够实现互联互通，数据共享和远程监控。

## 整体架构
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c0c885ee2.png)


## 主要功能及产品组件

注： 本手册中用到的中科时代的软件包，均可以从官网的子页面获取。官网提供的版本可能比本手册中提到的版本更高，一般情况下这不会影响您按照本手册的例子执行相应的操作

* 将搭建的客户端工程下载到工智机中运行，通过工智机里面的后台TCP/IP Client 和第三方的设备通过TCP/IP Server进行数据交互。

* 与第三方的TCP/IP服务端建立连接，收发数据，实现通信，当长时间不需要通信时，关闭建立的连接。

* TCPIP Client产品包括两部分组件

| **产品组件**                 | **描述说明**    |
| ------------------------ | ----------- |
| sf4200\_0.0.5\_amd64.deb | TCPIP RTE组件 |
| CmpTcpIp.library         | 上位机程序使用的库文件 |

---

### 安装卸载

**安装要求**

* 中科时代出厂的工智机；

* 工智机可以访问互联网；

* 熟悉基础的Linux操作命令

**安装过程**

* TCPIP Client产品有两个组件，所以要使用TCPIP Client需要从安装这两个组件开始，下面将详细介绍：

**1、工智机端安装TCPIP RTE组件**

* 上传deb包到工智机Linux环境的/home/sinsegye目录下

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c0d58c14b.png)


* 修改RTE的配置文件，ComponentManger模块下加入SF4200

* 重启RTE服务，使新加入的SF4200被调用

**2、IDE侧部署TCPIP Server的library**

* MetaFacture中点击最上面的菜单栏 ”工具“ -- ”库存储“ ；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c0deeb9b7.png)

* 弹出的对话窗中点击”安装“ -- 选中CmpTcpIp.library -- 点击“打开”；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c0e669fc9.png)
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c0ee5cb7c.png)
* 工程中双击“库管理器”  -- “添加库”  -- 双击“Sinsegye Tcp/Ip” ，加载库完成；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c0f75e90b.png)


**更新安装**

**1、升级工智机TCPIP Server RTE组件**

* 上传升级版deb包到工智机Linux环境的/home/sinsegye目录下，上传方法参考附录；

* 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

* 重启RTE服务，使新升级的的SF4200被调用

**2、升级IDE侧DataBase的library**

* MetaFacture中点击最上面的菜单栏 ”工具“ -- ”库存储“ ；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c10505fd8.png)

* 弹出的对话窗中点击”安装“ -- 选中CmpTcpIp.library -- 点击“打开”；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c10e25510.png)
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c1150aef0.png)

* 工程中双击“库管理器”  -- “添加库”  -- 双击“Sinsegye Tcp/Ip” ，加载库完成；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c11db7d29.png)

**卸载过程**

**1、卸载工智机TCPIP Server RTE组件**

* 工智机上执行命令卸载

* 修改RTE的配置文件，ComponentManger模块下去掉SF4200

* 重启RTE服务

**2、卸载IDE侧的TCPIP library**

* MetaFacture界面点击“工具” -- “库存储”&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c12a0d6ba.png)

* 对话框中选中安装的的TCPIP库，点击“卸载”
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c1491ab1a.png)


---
### 技术说明

**快速启动**

**（一）本例软、硬件配置**

**硬件：**

1. SX5100工智机 MetaOS V24.08.15\_SX5

2. Win10 PC



**软件：**

1. MetaFacutre V1.0.6.2

2. 第三方TCPIP Clinet工具TCP/UDP Socket调试工具 V2.3

**（二）本例实验要求及原理**

* 实验要求：按照“安装卸载”部分中的“安装过程”配置完成TCPIP Client环境

**1、实验原理**
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c152ae910.png)


* 通过FB\_SocketConnect和第三方的TCP/IP服务端建立连接，返回连接句柄，根据连接句柄结合FB\_SocketSend和FB\_SocketReceive进行数据的收发，从而实现通信，当长时间不需要通信时，可以根据FB\_SocketClose关闭建立的连接。

* 上位机和工智机使用EtherNet连接。

* 上位机上，MetaFacture下装工程到工智机。工程中会包含下面的试验操作步骤中的配置。

* 工智机与第三方TCPIP服务端通过EtherNet连接。

**（三）本例实验操作步骤**

**1、TCPIP Client与第三方TCPIP Server建立连接的实验步骤如下：**

* POU中声明区域调用TCPIP库的功能块FB\_SocketConnect

* POU中程序区域调用fbSocketConnect,配置TCPIP Server的ip、端口

* 第三方TCPIP Server启用监听后，触发TCPIP CLient的fbSoccketConnect的bExecute上升沿触发连接；连接成功后，查看第三方TCPIP Server状态变为已连接；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c15a595d5.png)


**2、TCPIP Client发送数据实验步骤如下：**

* POU中声明区域调用TCPIP库的功能块FB\_SocketSend

* POU中程序区域调用fbSocketSend,设置要写入的数据；

* 触发TCPIP CLient的fbSoccketSend的bExecute上升沿触发发送数据；第三方TCPIP Server接收到数据；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c16121b3e.png)


**3、TCPIP Client接收第三方server数据实验步骤如下：**

* POU中声明区域调用TCPIP库的功能块FB\_SocketReceive

* POU中程序区域调用fbSocketReceive,设置接收数据的地址；

* 第三方TCPIP Server发送数据后，触发TCPIP Client的fbSoccketReceive的bExecute上升沿触发接收数据；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c1681f4a8.png)


**4、TCPIP Client断开与第三方TCPIP Server的连接**

* POU中声明区域调用TCPIP库的功能块FB\_SocketClose

* POU中程序区域调用fbSocketClose

* 触发SocketClose的bExecute上升沿触发断开动作；查看第三方TCPIP Server状态由“已连接”变为“已启动监听”
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c16f29565.png)

**（四）实验注意点**

* 部分实验有先后顺序要求，建议按照文档中的顺序依次实验

---
### 功能介绍
#### 建立与TCPIP的连接

**功能块FB\_SocketConnect介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c178d79ea.png)

参数介绍

* 输入参数

| 参数名称        | 参数类型   | 描述                                            |
| ----------- | ------ | --------------------------------------------- |
| sRemoteHost | STRING | 远程服务器的 IP 地址（IPv4），格式为字符串                     |
| nRemotePort | UDINT  | 远程服务器的 IP 端口号                                 |
| bExecute    | BOOL   | 通过该输入的上升沿触发功能块                                |
| tTimeout    | TIME   | 该功能块执行允许的最大超时时间，即从触发到 到达该时间，如果还没有执行，就不执行，超时报警 |

* 输出参数

| 参数名称    | 参数类型        | 描述                                                                                |
| ------- | ----------- | --------------------------------------------------------------------------------- |
| bBusy   | BOOL        | 当功能块被激活时，被置为True，一直保持到收到确认信号                                                      |
| bError  | BOOL        | 如果在命令传输过程中发生错误，则在 bBusy 输出被重置后，此输出将被设置成True                                       |
| nErrId  | UDINT       | ![](images/image-16.png)如果 bError 输出被设置成True，则此参数返回 MetaFacture TCP/IP 连接服务器的错误编号 |
| hSocket | ST\_HSOCKET | 新打开的本地客户端套接字的 TCP/IP 连接句柄；结构体变量 ：句柄号、本地IP、远端IP                                    |

---
#### 发送数据

**功能块FB\_SocketSend介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c1873726d.png)


参数介绍

* 输入参数

| 参数名称     | 参数类型            | 描述                                            |
| -------- | --------------- | --------------------------------------------- |
| hSocket  | ST\_HSOCKET     | 要发送数据的通信伙伴的连接句柄                               |
| cbLen    | UDINT           | 要发送的数据字节数                                     |
| pSrc     | POINTER TO BYTE | 传输缓冲区的地址（指针）                                  |
| bExecute | BOOL            | 通过该输入的上升沿触发功能块                                |
| tTimeout | TIME            | 该功能块执行允许的最大超时时间，即从触发到 到达该时间，如果还没有执行，就不执行，超时报警 |

* 输出参数

| 参数名称   | 参数类型  | 描述                                                                                |
| ------ | ----- | --------------------------------------------------------------------------------- |
| bBusy  | BOOL  | 当功能块被激活时，被置为True，一直保持到收到确认信号                                                      |
| bError | BOOL  | 如果在命令传输过程中发生错误，则在 bBusy 输出被重置后，此输出将被设置成True                                       |
| nErrId | UDINT | ![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c194e4df9.png)
如果 bError 输出被设置成True，则此参数返回 MetaFacture TCP/IP 连接服务器的错误编号 |

---
#### 接收数据
**功能块FB\_SocketReceive介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c1a0d8eed.png)
参数介绍
* 输入参数

| 参数名称     | 参数类型            | 描述                                            |
| -------- | --------------- | --------------------------------------------- |
| hSocket  | ST\_HSOCKET     | 要接收数据的通信伙伴的连接句柄                               |
| cbLen    | UDINT           | 可用于读取数据的最大缓冲区大小（以字节为单位）                       |
| pDest    | POINTER TO BYTE | 接收缓冲区的地址（指针）                                  |
| bExecute | BOOL            | 上升沿触发TCPIP Server接收数据                         |
| tTimeout | Time            | 该功能块执行允许的最大超时时间，即从触发到 到达该时间，如果还没有执行，就不执行，超时报警 |

* 输出参数

| 参数名称      | 参数类型  | 描述                                                                                |
| --------- | ----- | --------------------------------------------------------------------------------- |
| bBusy     | BOOL  | 忙碌状态，True为忙碌，Flase不忙碌                                                             |
| bError    | BOOL  | 报错状态，True报错，Flase无报错                                                              |
| nErrId    | UDINT | ![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c1abc6cc1.png)
如果 bError 输出被设置成True，则此参数返回 MetaFacture TCP/IP 连接服务器的错误编号 |
| nRecBytes | UDINT | 最后成功接收的数据字节数                                                                      |

---
#### 关闭连接
**功能块FB\_SocketClose介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c1b44906b.png)

参数介绍

* 输入参数

| 参数名称     | 参数类型        | 描述                                            |
| -------- | ----------- | --------------------------------------------- |
| hSocket  | ST\_HSOCKET | 要关闭的监听器、远程或本地客户端套接字的连接句柄。                     |
| bExecute | BOOL        | 通过该输入的上升沿触发功能块                                |
| tTimeout | TIME        | 该功能块执行允许的最大超时时间，即从触发到 到达该时间，如果还没有执行，就不执行，超时报警 |

* 输出参数

| 参数名称   | 参数类型  | 描述                                                                                |
| ------ | ----- | --------------------------------------------------------------------------------- |
| bBusy  | BOOL  | 当功能块被激活时，被置为True，一直保持到收到确认信号                                                      |
| bError | BOOL  | 如果在命令传输过程中发生错误，则在 bBusy 输出被重置后，此输出将被设置成True                                       |
| nErrId | UDINT | ![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c1c1bf117.png)如果 bError 输出被设置成True，则此参数返回 MetaFacture TCP/IP 连接服务器的错误编号 |

---
### 错误
断开连接后再次连接，无法连接

* Client断开与TCPUDP Socket调试工具的连接后，再次去连接，无法连上；
![](https://resource.helplook.net/docker_production/3648ne/article/b9Zy8GKn/6800c1cae70a8.png)


* 需要重新下装TCPIP Client的工程，或者重新启动RTE才能再次连上；（已提交bug）